# Archivos de datos abiertos de Pacte per Barcelona


Este archivo ZIP contiene archivos para estudiar e investigar sobre esta plataforma de participación.


## Núcleo

### users

* id: El identificador único de la usuaria
* name: El nombre que se muestra de la usuaria
* nickname: El nombre de usuaria de la usuaria
* about: El texto "Acerca de" incluido en el perfil de usuaria
* avatar_url: El avatar de la usuaria
* profile_url: La URL del perfil de la usuaria
* direct_messages_enabled: Si la usuaria permite mensajes directos o no
* deleted: Si la usuaria fue eliminada o no
* badge: La insignia de la usuaria
* groups: El ID y el nombre del grupo de usuarias


### metrics

* day: La fecha en la que se creó esta métrica
* metric_type: El tipo de métrica
* cumulative: El número total de métricas en este día
* quantity: El número de métricas en este día


### taxonomies

* id: El identificador único de esta taxonomía
* name: El nombre de esta taxonomía
* parent_id: Los identificadores únicos de la taxonomía "madre" (si existe)
* weight: El orden en el que se muestra esta taxonomía
* children_count: El recuento de "hijas" (sub-taxonomías) que tiene esta taxonomía
* taxonomizations_count: El recuento de los recursos (debates, proyectos, propuestas, encuentros, resultados, etc.) que utilizan esta taxonomía
* created_at: La fecha en la que se creó esta taxonomía
* updated_at: La fecha en que esta taxonomía fue actualizada por última vez
* filters_count: La cantidad de filtros que utilizan esta taxonomía
* filter_items_count: La cantidad de filtros de elementos que utilizan esta taxonomía
* part_of: Utilizado para detectar si esta taxonomía es "hija" (sub-categoría) de otra taxonomía
* is_root: Cierto ("true"): si esta taxonomía no tiene ninguna "madre" (no cuelga de otra taxonomía)



## Espacios

### assemblies

* id: El identificador único del resultado
* title: El título de la asamblea
* slug: El nombre corto de la asamblea (usado para fines de identificación, para la URL)
* reference: La referencia única de la asamblea
* created_at: La fecha en la que se creó esta asamblea
* updated_at: La fecha de la última actualización de esta asamblea
* published_at: La fecha en la que se publicó esta asamblea
* follows_count: El número de usuarias que siguen esta asamblea
* hashtag: La etiqueta que utiliza la asamblea en Twitter/X
* short_description: Una breve descripción de la asamblea
* description: Una descripción larga de la asamblea
* promoted: Si la asamblea está destacada o no
* url: La URL de la asamblea
* subtitle: El subtítulo de la asamblea
* remote_hero_image_url: La URL de la imagen principal de la asamblea
* remote_banner_image_url: La URL de la imagen de la cabecera (imagen principal) de la asamblea
* announcement: La información del anuncio/aviso (llamada)
* developer_group: El grupo de promotor de la asamblea
* local_area: El área de organización de la asamblea
* meta_scope: Los metadatos del ámbito territorial de la asamblea
* participatory_scope: El ámbito territorial de la participación de la asamblea
* purpose_of_action: El propósito de la acción de la asamblea
* composition: La composición de la asamblea
* duration: La duración de la asamblea
* participatory_structure: La estructura participativa de la asamblea
* target: El objetivo de la asamblea
* decidim_scope_id: El ámbito territorial de asamblea
* area: El área a la que corresponde la asamblea
* scope: El ámbito territorial de asamblea
* scopes_enabled: Si el ámbito territorial está habilitado o no
* included_at: La fecha en que la asamblea fue incluida en la plataforma
* closing_date: La fecha de cierre de la asamblea
* created_by: Quién creó esta asamblea
* creation_date: La fecha de creación de esta asamblea
* closing_date_reason: Por qué se cerró la asamblea
* internal_organisation: La organización interna de esta asamblea
* is_transparent: Si la asamblea es transparente o no
* special_features: Qué características especiales tiene esta asamblea
* twitter_handler: Controlador de redes sociales para Twitter/X
* instagram_handler: Controlador de redes sociales para Instagram
* facebook_handler: Controlador de redes sociales para Facebook
* youtube_handler: Controlador de redes sociales para YouTube
* github_handler: Controlador de redes sociales para GitHub
* created_by_other: El área a la que corresponde la asamblea
* assembly_type: El tipo de asamblea



## Componentes

### meetings

* id: El identificador único del encuentro
* author: Los datos de autoría de este encuentro
* participatory_space: A qué espacio pertenece este encuentro (proceso participativo, asamblea, etc.)
* taxonomies: Las taxonomías a las que pertenece este encuentro
* component: El componente al que pertenece este encuentro
* title: El título del encuentro
* description: La descripción del encuentro
* start_time: La fecha y hora en que se inició este encuentro
* end_time: La fecha y hora en que terminó este encuentro
* attendees: El número de personas que asistieron a este encuentro
* contributions: El número de contribuciones realizadas en este encuentro por las asistentes
* organizations: Las organizaciones que asistieron a esta reunión
* address: La dirección del encuentro en caso de que este sea presencial y tenga una ubicación física
* location: La localización del encuentro
* reference: El identificador único del recurso en esta plataforma
* attachments: El número de archivos adjuntos en este encuentro
* url: La URL del encuentro
* related_proposals: Las propuestas relacionadas con este encuentro
* related_results: Los resultados relacionados con este encuentro
* published: Cuando se publicó el encuentro
* withdrawn: Si se canceló el encuentro
* withdrawn_at: Cuando fue retirado/cancelado este encuentro
* location_hints: Detalle de ubicación dentro del lugar donde se celebró el encuentro
* created_at: La fecha en la que se creó este encuentro
* updated_at: La fecha de la última actualización del encuentro
* latitude: La latitud del lugar de encuentro
* longitude: La longitud del lugar de encuentro
* follows_count: El número de seguidoras que tiene el encuentro
* private_meeting: Si el encuentro fue privado o no
* transparent: La visibilidad del encuentro para visitantes
* registration_form_enabled: Si se habilitó, o no, un formulario de inscripción al encuentro
* comments: Los datos de los comentarios del encuentro
* online_meeting_url: La URL de la sala de videoconferencias
* closing_visible: La visibilidad de la información de cierre del encuentro
* closing_report: Acta/Informe del encuentro cerrado
* attending_organizations: Las organizaciones que asistieron a este encuentro
* registration_url: La URL para inscribirse al encuentro
* decidim_user_group_id: ID del grupo de usuarias involucrado en el encuentro
* decidim_author_type: Tipo de autoría (origen) del encuentro
* video_url: La URL del vídeo del encuentro
* audio_url: Grabación de audio del encuentro
* closed_at: La fecha en la que se cerró el encuentro
* registration_terms: Los términos y condiciones de registro al encuentro que se aceptaron antes de participar
* available_slots: El número de plazas disponibles para el encuentro
* registrations_enabled: Si se habilitó la inscripción al encuentro
* customize_registration_email: Posibilidad de introducir un correo electrónico personalizado al registrarse en el encuentro
* type_of_meeting: El tipo de reunión
* iframe_access_level: El nivel de acceso de la sala de videoconferencias del encuentro
* iframe_embed_type: El tipo de visualización de la sala de videoconferencias del encuentro
* reserved_slots: El número de plazas reservadas que tenía el encuentro
* registration_type: El tipo de inscripción al encuentro


### pages

* id: El identificador único de esta página
* title: El título de la página
* body: El contenido de la página
* created_at: La fecha en la que se creó esta página
* updated_at: La fecha de la última actualización de esta página
* participatory_space: A qué espacio pertenece esta página (proceso participativo, asamblea, etc.)
* component: El componente al que pertenece la página
* url: La URL para esta página



